import multer from 'multer';

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, './uploads/');
  },

  filename: function (req, file, cb) {
    cb(null, Date.now() + file.originalname);
  },
});

const upload = multer({
  storage: storage,
  limits: { fileSize: 3145728 }, // 3MB limit
  //  limits: { fileSize: 2097152 }, // 2MB limit
  // limits: { fileSize: 1048576 }, // 1MB limit
});

export default upload;
