import cloudinary from '../helpers/cloudinary.js';
import fs from 'fs';
import path from 'path';
import Staff from '../models/staffModel.js';

// ===================Staff======================
// create Staff
export const createStaff = async (req, res, next) => {
  try {
    const {
      staff_name,
      staff_name_bd,
      position,
      phone_number,
      nid,
      address,
      date_of_birth,
      gender,
    } = req.body;
    // Validation
    if (
      !staff_name ||
      !staff_name_bd ||
      !nid ||
      !position ||
      !phone_number ||
      !address ||
      !date_of_birth ||
      !gender
    ) {
      return res.status(500).send({ message: 'All fields are required' });
    }

    // Images File Handling
    const urls = [];
    const file = req.file;

    if (file) {
      const { path } = file;
      const result = await cloudinary.uploader.upload(path);
      const data = {
        url: result.secure_url,
        public_id: result.public_id,
      };
      urls.push(data);
      fs.unlinkSync(path);
    }

    const staff = await Staff.create({
      staff_name,
      staff_name_bd,
      nid,
      position,
      phone_number,
      address,
      date_of_birth,
      gender,
      image: urls,
    });

    res.status(201).send({
      success: true,
      message: 'Staff created successfully',
      staff,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
    });
    next(error);
    console.error(error);
  }
};
//get all Staff
export const getStaff = async (req, res) => {
  try {
    const staffs = await Staff.find({}).sort({ createdAt: -1 });

    res.status(200).send({
      success: true,
      message: 'All Staff get successfully ',
      staffs,
    });
  } catch (error) {
    console.log(error);
  }
};
//get single staff
export const getSingleStaff = async (req, res) => {
  try {
    const id = req.params.id;
    const staff = await Staff.findById({ _id: id });

    res.status(200).send({
      success: true,
      message: 'Single Committee get successfully ',
      staff,
    });
  } catch (error) {
    console.log(error);
  }
};
//delete Staff
export const deleteStaff = async (req, res) => {
  try {
    const id = req.params.id;
    const staff = await Staff.findById({ _id: id });
    if (staff.image) {
      for (const image of staff.image) {
        const { public_id } = image;
        await cloudinary.uploader.destroy(public_id);
      }
    }

    await Staff.findByIdAndDelete(id);

    res.status(200).send({
      success: true,
      message: 'Staff deleted successfully',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Error while deleting Student',
      error,
    });
  }
};
//update Staff
export const updateStaff = async (req, res) => {
  try {
    const {
      staff_name,
      staff_name_bd,
      nid,
      position,
      phone_number,
      address,
      date_of_birth,
      gender,
    } = req.body;

    // console.log("",req.body);

    const id = req.params.id;

    // console.log('id========', id);
    // Validation
    if (
      !staff_name ||
      !staff_name_bd ||
      !position ||
      !nid ||
      !phone_number ||
      !address ||
      !date_of_birth ||
      !gender
    ) {
      return res.status(500).send({ message: 'All fields are required' });
    }

    const oldStaff = await Staff.findById({ _id: id });
    // console.log('old student ===========', oldStudent);
    // image handling
    const file = req.file;
    // console.log('file student ===========', file);

    const urls = file !== undefined ? [] : oldStaff.image;

    if (file) {
      // delete old images
      for (const image of oldStaff.image) {
        const { public_id } = image;
        await cloudinary.uploader.destroy(public_id);
      }

      const { path } = file;
      const result = await cloudinary.uploader.upload(path);
      const data = {
        url: result.secure_url,
        public_id: result.public_id,
      };
      urls.push(data);
      fs.unlinkSync(path);
    }

    const staff = await Staff.findByIdAndUpdate(
      id,
      {
        staff_name,
        staff_name_bd,
        nid,
        position,
        phone_number,
        address,
        date_of_birth,
        gender,
        qualification: oldStaff.qualification,
        image: urls,
      },
      { new: true }
    );

    await staff.save();

    res.status(201).send({
      success: true,
      message: 'staff Updated Successfully',
      staff,
    });
  } catch (error) {
    res.status(404).send({
      success: false,
      message: 'Something wrong!! Try again',
      error: error,
    });
    console.error(error);
  }
};

// ===================qualification Committee======================

// qualification
export const pushStaffQualification = async (req, res) => {
  try {
    const { name_exam, session, result, gpa, institute, board, group } =
      req.body;
    const staff = await Staff.findById(req.params.id);

    staff.qualification.push({
      name_exam,
      session,
      result,
      gpa,
      institute,
      board,
      group,
    });
    await staff.save();

    res.status(201).send({
      success: true,
      message: 'Qualification is added',
      staff,
    });
  } catch (error) {
    console.log(error);
  }
};
export const deleteStaffQualification = async (req, res) => {
  try {
    const { id, qid } = req.body;

    await Staff.updateOne(
      { _id: id },
      { $pull: { qualification: { _id: qid } } }
    );
    res.status(202).send({
      success: true,
      message: 'Qualification is deleted',
    });
  } catch (error) {
    console.log(error);
  }
};
// update qualification
export const updateStaffQualification = async (req, res) => {
  try {
    const {
      sid,
      qid,
      name_exam,
      session,
      result,
      gpa,
      institute,
      board,
      group,
    } = req.body;

    await Staff.updateOne(
      { _id: sid, 'qualification._id': qid },
      {
        $set: {
          'qualification.$.name_exam': name_exam,
          'qualification.$.session': session,
          'qualification.$.result': result,
          'qualification.$.gpa': gpa,
          'qualification.$.institute': institute,
          'qualification.$.board': board,
          'qualification.$.group': group,
        },
      }
    );

    res.status(200).send({
      success: true,
      message: 'Qualification is updated',
    });
  } catch (error) {
    console.log(error);
    res.status(500).send({
      success: false,
      message: 'Server error',
    });
  }
};
