import express from 'express';
import connectDB from './config/db.js';
import morgan from 'morgan';
import authRouter from './routers/authRoute.js';
import dotenv from 'dotenv';
import cors from 'cors';
import allRouter from './routers/allRoute.js';
dotenv.config();

import path from 'path';
import { fileURLToPath } from 'url';
import studentRouter from './routers/studentRoute.js';
import teacherRouter from './routers/teacherRoute.js';
import committeeRouter from './routers/committeeRoute.js';

const app = express();
const PORT = process.env.PORT || 8000;
// middleware
app.use(morgan('dev'));
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(cors());

app.use((req, res, next) => {
  res.setHeader('Content-Type', 'text/html; charset=utf-8');
  next();
});

app.get('/', (req, res) => {
  res.send('School management system server v3');
});

// view image from browser
const __filename = fileURLToPath(import.meta.url);
const __dirname = path.dirname(__filename);

app.use('/uploads', express.static('uploads'));
app.use(express.static(path.join(__dirname, 'uploads')));

// app.use(express.static(path.join(__dirname, "./build")));

// routers
app.use('/api/auth', authRouter);
app.use('/api/student', studentRouter);
app.use('/api/teacher', teacherRouter);
app.use('/api/committee', committeeRouter);

app.use('/api/all', allRouter);

app.listen(PORT, async () => {
  console.log(`Server is running ${PORT}`);
  await connectDB();
});
