import mongoose, { Schema, model } from 'mongoose';
const noticeSchema = new Schema(
  {
    title: {
      type: String,
      required: [true, 'title is required'],
    },
    description: {
      type: String,
      trim: false, // Preserve line breaks
      required: [true, 'description is required'],
    },
    pdf_file: {
      type: String,
    },
  },
  { timestamps: true }
);
const Notice = mongoose.model('Notice', noticeSchema);

export default Notice;
