import express from 'express';
import { isAdmin, requiredSignIn } from '../middleware/authMiddleware.js';
import upload from '../helpers/multer.js';
import {
  createTeacher,
  deleteQualification,
  deleteTeacher,
  getSingleTeacher,
  getTeacher,
  pushQualification,
  updateQualification,
  updateTeacher,
} from '../controllers/teacherController.js';

const teacherRouter = express.Router();
// ================Teacher =====================
//create teacher
teacherRouter.post(
  '/teacher_create',
  upload.single('image'),
  requiredSignIn,
  isAdmin,
  createTeacher
);
//get all teacher
teacherRouter.get('/get_all_teacher', getTeacher);
//get all teacher
teacherRouter.get('/get_single_teacher/:id', getSingleTeacher);
//delete teacher
teacherRouter.delete(
  '/teacher_delete/:id',
  requiredSignIn,
  isAdmin,
  deleteTeacher
);
teacherRouter.put(
  '/teacher_update/:id',
  upload.single('image'),
  requiredSignIn,
  isAdmin,
  updateTeacher
);

// ===============Teacher qualification add ====================
// add qualification
teacherRouter.post(
  '/add_qualification/:id',
  requiredSignIn,
  isAdmin,
  pushQualification
);
// Update qualification

teacherRouter.post('/update_q', requiredSignIn, isAdmin, updateQualification);

// delete qualification  delete
teacherRouter.post(
  '/qualification_delete',
  requiredSignIn,
  isAdmin,
  deleteQualification
);

export default teacherRouter;
