import { Schema, model } from 'mongoose';

const teacherSchema = new Schema(
  {
    teacher_name: {
      type: String,
      require: [true, 'Name is Required'],
      trim: true,
    },
    teacher_name_bd: {
      type: String,
      require: [true, 'Name is Required'],
      trim: true,
    },
    nid: {
      type: String,
      require: [true, 'nid is Required'],
    },
    joining_date: {
      type: String,
      require: [true, 'joining_date is Required'],
    },
    retirement_date: {
      type: String,
      require: [true, 'retirement_date is Required'],
    },
    phone_number: {
      type: String,
      required: [true, 'Phone Number is Required'],
    },
    address: {
      type: String,
      required: true,
    },
    gender: {
      type: String,
      required: true,
    },
    date_of_birth: {
      type: String,
      required: true,
    },
    index: {
      type: String,
      required: true,
    },
    designation: {
      type: String,
      required: true,
    },
    image: {
      type: Array,
    },
    qualification: [
      {
        name_exam: String,
        session: String,
        result: String,
        gpa: String,
        institute: String,
        board: String,
        group: String,
      },
    ],
  },
  { timestamps: true }
);

const Teacher = model('teacher', teacherSchema);

export default Teacher;
