import { Schema, model } from 'mongoose';

const staffSchema = new Schema(
  {
    staff_name: {
      type: String,
      require: [true, 'Name is Required'],
      trim: true,
    },
    staff_name_bd: {
      type: String,
      require: [true, 'Name is Required'],
      trim: true,
    },
    phone_number: {
      type: String,
      required: [true, 'Phone Number is Required'],
    },
    address: {
      type: String,
      required: true,
    },
    nid: {
      type: String,
      required: true,
    },

    gender: {
      type: String,
      required: true,
    },
    date_of_birth: {
      type: String,
      required: true,
    },
    position: {
      type: String,
      required: true,
    },
    image: {
      type: Array,
    },
    qualification: [
      {
        name_exam: String,
        session: String,
        result: String,
        gpa: String,
        institute: String,
        board: String,
        group: String,
      },
    ],
  },
  { timestamps: true }
);

const Staff = model('staff', staffSchema);

export default Staff;
