import { Schema, model } from 'mongoose';

const speechSchema = new Schema(
  {
    title: {
      type: String,
      required: true,
    },
    name: {
      type: String,
      required: true,
    },
    disc: {
      type: String,
      trim: false,
      required: true,
    },
    image: {
      type: Array,
    },
  },
  { timestamps: true }
);

const Speech = model('speech', speechSchema);

export default Speech;
