import { Schema, model } from 'mongoose';

const resultSchema = new Schema(
  {
    student_name: {
      type: String,
      require: [true, 'Name is Required'],
      trim: true,
    },
    exam_year: {
      type: String,
      required: [true, 'Year is Required'],
    },
    gpa: {
      type: String,
      required: true,
    },
    position: {
      type: String,
      required: true,
    },
    total_result: {
      type: String,
      required: true,
    },
    exam_name: {
      type: String,
      required: true,
    },

    class_roll: {
      type: String,
      required: true,
    },
    class_name: {
      type: String,
      required: true,
    },
    image: {
      type: String,
    },
  },
  { timestamps: true }
);

const Result = model('results', resultSchema);

export default Result;
