import { Schema, model } from 'mongoose';

const classRoutineSchema = new Schema(
  {
    subject_name: {
      type: String,
      require: [true, 'subject is Required'],
    },
    class_name: {
      type: String,
      required: [true, 'class is Required'],
    },
    teacher_name: {
      type: String,
      required: true,
    },

    time_from: {
      type: String,
      required: true,
    },
    time_to: {
      type: String,
      required: true,
    },
    day_name: {
      type: String,
      required: true,
    },
  },
  { timestamps: true }
);

const ClassRoutine = model('classroutine', classRoutineSchema);

export default ClassRoutine;
